//----------------------------------------------------------------------------//
//- CadAnbieter.pas ----------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Dialog zum Erfassen und bearbeiten von Anbietern.                          //
// Abgeleitet von CadBasisErfassen                                            //
//----------------------------------------------------------------------------//

unit CadAnbieter;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBasisErfassen, StdCtrls, CafAdressdaten, ExtCtrls,
  CaoPersonenListe;

//------------------------------------------------------------------------------

type
  TCaDlgAnbieter = class(TDlgBasisErfassen)
    m_FrmAdressdaten: TFrmAdressdaten;
    m_ImgPersonen   : TImage;

    //--------------------------------------------------------------------------

    procedure FormShow         (Sender: TObject);
    procedure FormCloseQuery   (Sender: TObject; var CanClose: Boolean);

  //----------------------------------------------------------------------------

  private
    m_obAnbieter: TCaoPersonen;

  //----------------------------------------------------------------------------

  protected
    procedure PrtSetTitles; override;

  //----------------------------------------------------------------------------

  public
    function ShowModal(obAnbieter: TCaoPersonen): Integer; reintroduce;

  //----------------------------------------------------------------------------

  end; // TCaDlgAnbieter

//------------------------------------------------------------------------------

var
  CaDlgAnbieter: TCaDlgAnbieter;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CamConst;

//------------------------------------------------------------------------------

procedure TCaDlgAnbieter.PrtSetTitles;
begin
  m_sTitelNeu        := c_sAnbieterNeu;
  m_sTitelBearbeiten := c_sAnbieterBearbeiten;
  m_sTitelKopieren   := c_sAnbieterKopieren;
end; // TCaDlgAnbieter.PrtSetTitles

//------------------------------------------------------------------------------

procedure TCaDlgAnbieter.FormShow(Sender: TObject);
begin
  inherited;
  // Frame initialisieren
  m_FrmAdressdaten.ShowFrame(m_obAnbieter);
end; // TCaDlgAnbieter.FormShow

//------------------------------------------------------------------------------

function TCaDlgAnbieter.ShowModal(obAnbieter: TCaoPersonen): Integer;
begin
  m_obAnbieter := obAnbieter;
  result := inherited ShowModal(m_obAnbieter.iStatus);
end; // TCaDlgAnbieter.ShowModal

//------------------------------------------------------------------------------

procedure TCaDlgAnbieter.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  inherited;
  m_FrmAdressdaten.CloseFrame(ModalResult);
end; // TCaDlgAnbieter.FormCloseQuery

//------------------------------------------------------------------------------

end. // CadAnbieter
